//
//  YHInfoItemOptionView.swift
//  galaxy
//
//  Created by edy on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInfoItemOption {
    var value: String = ""
    var isSelect: Bool = false
}

class YHInfoItemOptionView: UIView {
    
    let btnHeight = 32.0
    let titleMaxWidth = 113.0
    let baseBtnTag = 9527
    var options: [String] = [] {
        didSet {
            for (index, text) in options.enumerated() {
                if let btn = self.viewWithTag(baseBtnTag + index) as? UIButton {
                    btn.setTitle(text, for: .normal)
                }
            }
        }
    }
    var selectBlock: ((Int) -> Void)?
    
    var title: String = "" {
        didSet {
            self.titleLabel.text = title
            
            let height = self.getHeight(text: title, font: titleLabel.font, width: titleMaxWidth)
            var isOneLine = false
            if height <= 20 {
                // 文字只显示一行
                isOneLine = true
            } else {
                // 文字超过一行
                isOneLine = false
            }
            
            titleLabel.snp.remakeConstraints { make in
                if isOneLine {
                    make.height.equalTo(20)
                }
                make.edges.equalToSuperview()
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
            
        }
    }
    
    var tips: String = "" {
        didSet {
            let isShowTips = !tips.isEmpty
            tipsLabel.text = tips
            tipsLabel.snp.updateConstraints { make in
                make.left.right.equalToSuperview()
                make.top.equalTo(titleView.snp.bottom).offset(isShowTips ? 5.0 : 0.0)
                make.height.equalTo(isShowTips ? 17.0 : 0.0)
                make.bottom.equalTo(-titleGap)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    var selectIndex: Int = -1 {
        didSet {
            for (index, _) in options.enumerated() {
                if let btn = self.viewWithTag(baseBtnTag + index) as? UIButton {
                    setOptionBtnSelected(btn: btn, isSelect: index == selectIndex)
                }
            }
        }
    }
    
    var titleGap = 16.0 {
        didSet {
            titleView.snp.updateConstraints { make in
                make.top.equalTo(titleGap)
            }
            
            tipsLabel.snp.updateConstraints { make in
                make.bottom.equalTo(-titleGap)
            }
            
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    private lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = .failColor
        return label
    }()
    
    func createOptionButton() -> UIButton {
        
        let btn = UIButton()
        btn.backgroundColor = UIColor.init(hex: 0xF8F9FB)
        btn.titleLabel?.font = .PFSC_R(ofSize: 13)
        btn.setTitle("", for: .normal)
        btn.layer.cornerRadius = self.btnHeight/2.0
        btn.clipsToBounds = true
        return btn
    }
    
    func setOptionBtnSelected(btn: UIButton, isSelect: Bool) {
        btn.layer.borderWidth = isSelect ? 1.0 : 0.0
        btn.layer.borderColor = isSelect ? UIColor.brandMainColor.cgColor : nil
        btn.setTitleColor(isSelect ? UIColor.brandMainColor : UIColor.init(hex: 0x222222), for: .normal)
    }
    
    // 禁用按钮且更新为未选择状态并将标题置灰
    func setOptionBtnDisabledAndUnselected(_ index: Int) {
        if let btn = self.viewWithTag(baseBtnTag + index) as? UIButton {
            setOptionBtnSelected(btn: btn, isSelect: false)
            btn.isEnabled = false
            btn.setTitleColor(.mainTextColor(alpha: 0.18), for: .normal)
        }
    }
    
    // 是否禁用按钮点击
    func setOptionBtnDisabled(index: Int, disabled: Bool) {
        if let btn = self.viewWithTag(baseBtnTag + index) as? UIButton {
            btn.isEnabled = !disabled
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.addSubview(titleView)
        self.addSubview(tipsLabel)

        titleView.addSubview(titleLabel)
        
        let firstBtn = self.createOptionButton()
        firstBtn.tag = baseBtnTag + 0
        setOptionBtnSelected(btn: firstBtn, isSelect: false)
        firstBtn.addTarget(self, action: #selector(didOptionBtnClicked(_:)), for: .touchUpInside)
        self.addSubview(firstBtn)
        
        let secondBtn = self.createOptionButton()
        secondBtn.tag = baseBtnTag + 1
        setOptionBtnSelected(btn: secondBtn, isSelect: false)
        secondBtn.addTarget(self, action: #selector(didOptionBtnClicked(_:)), for: .touchUpInside)
        self.addSubview(secondBtn)
        
        self.addSubview(lineView)
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(-0.5)
            make.height.equalTo(0.5)
        }

        titleView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(titleGap)
            make.width.equalTo(titleMaxWidth)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(titleView.snp.bottom).offset(0)
            make.height.equalTo(0)
            make.bottom.equalTo(-titleGap)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        secondBtn.snp.makeConstraints { make in
            make.right.equalTo(0)
            make.size.equalTo(CGSize(width: 69, height: 32))
            make.centerY.equalTo(titleView)
        }
        
        firstBtn.snp.makeConstraints { make in
            make.right.equalTo(secondBtn.snp.left).offset(-8)
            make.size.equalTo(CGSize(width: 69, height: 32))
            make.centerY.equalTo(titleView)
        }
    }
    
    @objc func didOptionBtnClicked(_ sender: UIButton) {
        
        if let btn1 = self.viewWithTag(baseBtnTag + 0) as? UIButton {
            setOptionBtnSelected(btn: btn1, isSelect: sender.tag == baseBtnTag + 0)
        }
        if let btn2 = self.viewWithTag(baseBtnTag + 1) as? UIButton {
            setOptionBtnSelected(btn: btn2, isSelect: sender.tag == baseBtnTag + 1)
        }
        
        selectBlock?(sender.tag-baseBtnTag)
    }
    
    func getHeight(text: String, font: UIFont, width: CGFloat) -> CGFloat {
        let size = CGSize.init(width: width, height: CGFloat(MAXFLOAT))
        let dic = [NSAttributedString.Key.font: font]
        let strSize = text.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context: nil).size
        return CGSize(width: strSize.width, height: ceil(strSize.height)).height
    }
}
